/*
 =====================================================================================================================
  Resource API: "patient-facilities"

 [GET] "/VeteranAppointmentRequestService/v4/rest/direct-scheduling/institutions"
    Attributes:
        site-code (Array<Number>) The facilities that the patient is registered at
        clinical-service (Number) The code for the type of care they are requesting

 =====================================================================================================================

 Note: var-resources does not recognize lists using the attribute-name[]=value therefore the traditional flag is being
  added to the ajax request

 =====================================================================================================================
 */

define([
    'underscore',
    'App',
    'models/abstract-collection',
    'modules/new-appointment-request/resources/common/facility/model',
], function(_, app, Collection, Model) {
    'use strict';


    return Collection.extend({
        model: Model,
        comparator: 'name',
        resourceName: 'patient-facilities',

        /**
         * Builds the url for the fetch.  Invoked by backbone using _.result(this, 'url')
         * @return {*}
         */
        url: function() {
            var resource = this.getResource();
            return resource.formatHref({});
        },

        /**
         * Creates the data to fetch patient facilities
         * @param {string} typeOfCare The type of care code
         * @param {string} facilityCode
         * @param {string} parentCode
         * @return {xhr}
         */
        fetchPatientFacilities: function(typeOfCare, facilityCode, parentCode) {
            return this.fetch({
                data: {
                    'facility-code': facilityCode,
                    'parent-code': parentCode,
                    'clinical-service': typeOfCare,
                },
            });
        },

        /**
         * Creates an array used for section views
         * @param {array} clinicsInstitutionCodes a list of all the institution codes from the clinics
         * @return {array}
         */
        toSectionData: function(clinicsInstitutionCodes) {
            return this.map(function(model) {
                return model.toSectionData(clinicsInstitutionCodes);
            });
        },

        /**
         * A shortcut function to avoid nesting in _getFetchData
         * To be used a part of _.map
         * @param {Backbone.Model} model
         * @return {string}
         * @private
         */
        _mapCodes: function(model) {
            return model.get('facilityCode');
        },
    });
});
